;*****************************************************************************        
;
;   Module:     equates.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               equate statements for variables and constants
;
;*****************************************************************************        


; The following determine the size and starting index of the main menu
MENU_SIZE           EQU D'10'            
MENU_FIRST_ENTRY    EQU 0


BAUD_CONSTANT       EQU 40            ;Constant for baud generator for 19200 baud
                                    ;Fosc is 20MHz

RS232_PWR           EQU 5           ; Pin driving RS232 power line

LCD_DATA            EQU PORTD        ; LCD data lines interface
LCD_DATA_TRIS       EQU TRISD
    
; PORTA bits
LCD_E               EQU 0            ; LCD Enable control line
LCD_RW              EQU 1            ; LCD Read/Write control line
LCD_RS              EQU 2            ; LCD Register-Select control line
LCD_PWR             EQU 3

; Flags1 bits
INT_RTC_TICK        EQU 0
INT_KEYPRESS        EQU 1

; Flags2 bits
RS232_FLAGS2        EQU 0
VALIDDATA_FLAGS2    EQU 1           ; used by viewStats



; Bank 0 RAM
lcdTmp              EQU 0x20        ; LCD subroutines internal use
DMCount             EQU 0x21        ; Index to table strings
menuLine            EQU 0x22        ; A counter used by dspMenu
delay1              EQU 0x23        ; Used bu 100us delay routine
delay2              EQU 0x24        
delay3              EQU 0x25        
lcdCtrl             EQU 0x26        ; LCD control lines interface mirror
lcdTmp2             EQU 0x27        ; Used by display.inc
rawKey              EQU 0x28
keyTmp1             EQU 0x29        ; Used by ui.inc for key scanning
keyTmp              EQU 0x2A        ; Used by ui.inc for key debouncing
menuItem            EQU 0x2B        ; Holds the first menu entry to be displayed
flags1              EQU 0x2c        ; interrupt flags
daysBCD             EQU 0x2d
monthsBCD           EQU 0x2e
yearsBCD            EQU 0x2f
hoursBCD            EQU 0x30
minutesBCD          EQU 0x31
flags2              EQU 0x32        ; system flags
RXBufferCount       EQU 0x33
Command             EQU 0x34
CommandParam1_L     EQU 0x35
CommandParam1_H     EQU 0x36
CommandParam2_L     EQU 0x37
CommandParam2_H     EQU 0x38

RXBuffer            EQU 0x39        ; 16 byte buffer
; The following temporary variables
; share space with the RXBuffer - This *is* safe!
wordBCDTmpA0        EQU 0x39        ; MSB
wordBCDTmpA1        EQU 0x3A
wordBCDTmpA2        EQU 0x3B        ; LSB
wordBCDTmpB0        EQU 0x3C        ; MSB
wordBCDTmpB1        EQU 0x3D
wordBCDTmpB2        EQU 0x3E        ; LSB
wordBCDTmpC0        EQU 0x3F        ; MSB
wordBCDTmpC1        EQU 0x40
wordBCDTmpC2        EQU 0x41        ; LSB
wordBCDTmpD0        EQU 0x42        ; MSB
wordBCDTmpD1        EQU 0x43
wordBCDTmpD2        EQU 0x44        ; LSB
byteBCDTmpA         EQU 0x45
byteBCDTmpB         EQU 0x46
byteBCDTmpC         EQU 0x47
byteBCDTmpD         EQU 0x48


eepAddH             EQU 0x49
eepAddL             EQU 0x4a
eepData             EQU 0x4b
eepNum              EQU 0x4c
intTick             EQU 0x4d        ; Counts 15s interrupts, to generate 1minute tick
DataPointer         EQU 0x4e        ; pointer to data in buffer
daysInMonthBCD      EQU 0x4f
intTmp              EQU 0x50
daysBCDTmp          EQU 0x51
monthsBCDTmp        EQU 0x52
yearsBCDTmp         EQU 0x53
hoursBCDTmp         EQU 0x54
minutesBCDTmp       EQU 0x55
tmpNumRecH          EQU 0x56
tmpNumRecL          EQU 0x57
tmpNextRecH         EQU 0x58
tmpNextRecL         EQU 0x59
tmpPrevRecH         EQU 0x5A
tmpPrevRecL         EQU 0x5B
kbdTimeout          EQU 0x5c   
minOffset           EQU 0x5d     
distanceDspLen      EQU 0x60
volumeDspLen        EQU 0x61
pcTmp               EQU 0x62
arTmp               EQU 0x63
curPos              EQU 0x64        ; cursor position
BCDTmpE0            EQU 0x65
BCDTmpE1            EQU 0x66
BCDTmpE2            EQU 0x67

daysBCDTmp2         EQU 0x68        ; Used in checkReminders
monthsBCDTmp2       EQU 0x69
yearsBCDTmp2        EQU 0x6A
BCDTmpF0            EQU 0x6B       ; tmp last mileage recorded
BCDTmpF1            EQU 0x6C
BCDTmpF2            EQU 0x6D

viewType            EQU 0x6E        ; input parameter to viewRemindersB1

; Temporary variables used by view stats
miles1_0            EQU 0x6F
miles1_1            EQU 0x70
miles1_2            EQU 0x71
miles2_0            EQU 0x72
miles2_1            EQU 0x73
miles2_2            EQU 0x74
fuel1_0             EQU 0x75
fuel1_1             EQU 0x76
fuel1_2             EQU 0x77
fuel2               EQU 0x78
mmyy1_0             EQU 0x79
mmyy1_1             EQU 0x7A
mmyy2_0             EQU 0x7B
mmyy2_1             EQU 0x7C

PCLATH_TEMP         EQU 0x7d        ; Exists in all banks
STATUS_TEMP         EQU 0x7e        ; Exists in all banks
W_TEMP              EQU 0x7f        ; Exists in all banks
